// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     chrome/browser/media/router/media_router.mojom
//

package org.chromium.mojom.media_router.interfaces;

public final class Issue extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 64;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(64, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public static final class Severity {
    
        public static final int FATAL = 0;
        public static final int WARNING = FATAL + 1;
        public static final int NOTIFICATION = WARNING + 1;
    
        private Severity() {}
    
    }

    public static final class ActionType {
    
        public static final int DISMISS = 0;
        public static final int LEARN_MORE = DISMISS + 1;
    
        private ActionType() {}
    
    }

    public String routeId;
    public int severity;
    public boolean isBlocking;
    public String title;
    public String message;
    public int defaultAction;
    public int[] secondaryActions;
    public String helpUrl;

    private Issue(int version) {
        super(STRUCT_SIZE, version);
    }

    public Issue() {
        this(0);
    }

    public static Issue deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static Issue decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        Issue result = new Issue(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.routeId = decoder0.readString(8, true);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.severity = decoder0.readInt(16);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.isBlocking = decoder0.readBoolean(20, 0);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.title = decoder0.readString(24, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.message = decoder0.readString(32, true);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.defaultAction = decoder0.readInt(40);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.secondaryActions = decoder0.readInts(48, org.chromium.mojo.bindings.BindingsHelper.ARRAY_NULLABLE, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.helpUrl = decoder0.readString(56, true);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(routeId, 8, true);
        encoder0.encode(severity, 16);
        encoder0.encode(isBlocking, 20, 0);
        encoder0.encode(title, 24, false);
        encoder0.encode(message, 32, true);
        encoder0.encode(defaultAction, 40);
        encoder0.encode(secondaryActions, 48, org.chromium.mojo.bindings.BindingsHelper.ARRAY_NULLABLE, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        encoder0.encode(helpUrl, 56, true);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        Issue other = (Issue) object;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.routeId, other.routeId))
            return false;
        if (this.severity != other.severity)
            return false;
        if (this.isBlocking != other.isBlocking)
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.title, other.title))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.message, other.message))
            return false;
        if (this.defaultAction != other.defaultAction)
            return false;
        if (!java.util.Arrays.equals(this.secondaryActions, other.secondaryActions))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.helpUrl, other.helpUrl))
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(routeId);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(severity);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(isBlocking);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(title);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(message);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(defaultAction);
        result = prime * result + java.util.Arrays.hashCode(secondaryActions);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(helpUrl);
        return result;
    }
}

